/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api.dataexchange.handler.autosync;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.loader.api.FabricLoader;
import ru.bclib.BCLib;
import ru.bclib.api.dataexchange.DataExchangeAPI;
import ru.bclib.api.dataexchange.SyncFileHash;
import ru.bclib.api.dataexchange.handler.autosync.AutoFileSyncEntry;
import ru.bclib.api.dataexchange.handler.autosync.AutoSyncID;
import ru.bclib.api.dataexchange.handler.autosync.FileContentWrapper;
import ru.bclib.api.dataexchange.handler.autosync.SyncFolderDescriptor;
import ru.bclib.config.Configs;
import ru.bclib.config.ServerConfig;
import ru.bclib.util.PathUtil;

public class AutoSync {
    public static final String SYNC_CATEGORY = "auto_sync";
    public static final SyncFolderDescriptor SYNC_FOLDER = new SyncFolderDescriptor("BCLIB-SYNC", FabricLoader.getInstance().getGameDir().resolve("bclib-sync").normalize().toAbsolutePath(), true);
    protected static final List<BiConsumer<AutoSyncID, File>> onWriteCallbacks = new ArrayList<BiConsumer<AutoSyncID, File>>(2);
    private static final List<AutoFileSyncEntry> autoSyncFiles = new ArrayList<AutoFileSyncEntry>(4);
    static final List<SyncFolderDescriptor> syncFolderDescriptions = Arrays.asList(SYNC_FOLDER);
    private List<String> syncFolderContent;
    private static boolean didRegisterAdditionalMods = false;

    public static void addOnWriteCallback(BiConsumer<AutoSyncID, File> callback) {
        onWriteCallbacks.add(callback);
    }

    public static List<AutoFileSyncEntry> getAutoSyncFiles() {
        return autoSyncFiles;
    }

    public static void addAutoSyncFileData(String modID, File fileName, boolean requestContent, NeedTransferPredicate needTransfer) {
        if (!PathUtil.isChildOf(PathUtil.GAME_FOLDER, fileName.toPath())) {
            BCLib.LOGGER.error(fileName + " is outside of Game Folder " + PathUtil.GAME_FOLDER);
        } else {
            autoSyncFiles.add(new AutoFileSyncEntry(modID, fileName, requestContent, needTransfer));
        }
    }

    public static void addAutoSyncFileData(String modID, String uniqueID, File fileName, boolean requestContent, NeedTransferPredicate needTransfer) {
        if (!PathUtil.isChildOf(PathUtil.GAME_FOLDER, fileName.toPath())) {
            BCLib.LOGGER.error(fileName + " is outside of Game Folder " + PathUtil.GAME_FOLDER);
        } else {
            autoSyncFiles.add(new AutoFileSyncEntry(modID, uniqueID, fileName, requestContent, needTransfer));
        }
    }

    static void didReceiveFile(AutoSyncID aid, File file) {
        onWriteCallbacks.forEach(fkt -> fkt.accept(aid, file));
    }

    protected List<String> getSyncFolderContent() {
        if (this.syncFolderContent == null) {
            return new ArrayList<String>(0);
        }
        return this.syncFolderContent;
    }

    protected static void loadSyncFolder() {
        if (Configs.SERVER_CONFIG.isOfferingFiles()) {
            syncFolderDescriptions.forEach(desc -> desc.loadCache());
        }
        if (!didRegisterAdditionalMods && Configs.SERVER_CONFIG.isOfferingMods()) {
            didRegisterAdditionalMods = true;
            List<String> modIDs = Configs.SERVER_CONFIG.get(ServerConfig.ADDITIONAL_MODS);
            if (modIDs != null) {
                modIDs.stream().forEach(modID -> DataExchangeAPI.registerModDependency(modID));
            }
        }
    }

    protected static SyncFolderDescriptor getSyncFolderDescriptor(String folderID) {
        return syncFolderDescriptions.stream().filter(d -> d.equals(folderID)).findFirst().orElse(null);
    }

    protected static Path localBasePathForFolderID(String folderID) {
        SyncFolderDescriptor desc = AutoSync.getSyncFolderDescriptor(folderID);
        if (desc != null) {
            return desc.localFolder;
        }
        BCLib.LOGGER.warning("Unknown Sync-Folder ID '" + folderID + "'", new Object[0]);
        return null;
    }

    public static void registerSyncFolder(String folderID, Path localBaseFolder, boolean removeAdditionalFiles) {
        if (PathUtil.isChildOf(PathUtil.GAME_FOLDER, localBaseFolder = localBaseFolder.normalize())) {
            SyncFolderDescriptor desc = new SyncFolderDescriptor(folderID, localBaseFolder, removeAdditionalFiles);
            if (syncFolderDescriptions.contains(desc)) {
                BCLib.LOGGER.warning("Tried to override Folder Sync '" + folderID + "' again.", new Object[0]);
            } else {
                syncFolderDescriptions.add(desc);
            }
        } else {
            BCLib.LOGGER.error(localBaseFolder + " (from " + folderID + ") is outside the game directory " + PathUtil.GAME_FOLDER + ". Sync is not allowed.");
        }
    }

    @FunctionalInterface
    public static interface NeedTransferPredicate {
        public boolean test(SyncFileHash var1, SyncFileHash var2, FileContentWrapper var3);
    }

    static final class AutoSyncTriple {
        public final SyncFileHash serverHash;
        public final byte[] serverContent;
        public final AutoFileSyncEntry localMatch;

        public AutoSyncTriple(SyncFileHash serverHash, byte[] serverContent, AutoFileSyncEntry localMatch) {
            this.serverHash = serverHash;
            this.serverContent = serverContent;
            this.localMatch = localMatch;
        }

        public String toString() {
            return this.serverHash.modID + "." + this.serverHash.uniqueID;
        }
    }
}

